/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

/*
 * Check to make sure decompose returns what it should
 */

#include <stdio.h>
#include <stdlib.h>
#include "mx_auto_config.h"
#include "myriexpress.h"

#define MY_EID 1
#define MY_FILTER 0x12345678

int
main()
{
  mx_return_t rc;
  mx_endpoint_t ep;
  mx_endpoint_addr_t ep_addr;
  uint64_t nicid;
  uint32_t eid;

  rc = mx_init();

  rc = mx_open_endpoint(MX_ANY_NIC, MY_EID, MY_FILTER, NULL, 0, &ep);
  if (rc != MX_SUCCESS) {
    fprintf(stderr,"error opening endpoint\n");
    exit(1);
  }

  rc = mx_get_endpoint_addr(ep, &ep_addr);
  if (rc != MX_SUCCESS) {
    fprintf(stderr,"error getting endpoint address\n");
    exit(1);
  }

  rc = mx_decompose_endpoint_addr(ep_addr, &nicid, &eid);
  if (rc != MX_SUCCESS) {
    fprintf(stderr,"error decomposing endpoint address\n");
    exit(1);
  }

  /* no error yet */
  rc = 0;

  if (eid != MY_EID) {
    printf("eid should be %d, is %d\n", MY_EID, eid);
    rc = 1;
  }

  if (rc != 0) {
    printf("**FAILED**\n");
  }

  mx_close_endpoint(ep);
  mx_finalize();

  exit(rc);
}
